; Copyright 1999 by Henter-Joyce, Inc.
;For the Windows Calculator
;03/25/99 by j.c

Include "hjconst.jsh"
Include "hjglobal.jsh"
Include "calc.jsh"
Include "calc.jsm"

Script ScriptFileName ()
ScriptAndappNames (calculatorApplicationName)
EndScript

Function AutoStartEvent ()
var
  int IVerbosity,
  int IControlID,
  handle WinHandle
  let IVerbosity = GetVerbosity ()
  let IControlID = GetControlID (GetFocus ())
  let WinHandle = FindDescendantWindow (GetRealWindow (GetCurrentWindow  ()), SIN_Button)
If (GetWindowsOS () <= os_win95) then
  SwitchToScriptFile ("calc95", "calc")
EndIf
If (CalculatorFirsttime == 0) then
  let CalculatorFirstTime = 1
If (IVerbosity == beginner) then
  Say(msg1, ot_help)  ;"for Jaws Hot Keys for Calculator Use Insert + H ",
  Say(msg2, ot_help)  ;"For Screen Sensitive Help use Insert + F1",
  Return
EndIf
EndIf
EndFunction

Script CalculatorToggle ()
;toggle between scientific and standard modes
var
int echo,;
int verb
let echo=GetScreenecho();
let verb=GetVerbosity();
while GetScreenEcho()>0
ScreenEcho()
Endwhile
while GetVerbosity()<2
VerbosityLevel()
Endwhile
If (CalculatorView == ScientificCalculator) then
{alt+v}
{t}
while GetScreenecho()!=echo
ScreenEcho()
Endwhile
while GetVerbosity()!=verb
VerbosityLevel()
Endwhile
if getverbosity()==0 then
Say (msg3, ot_message) ;"The standard calculator has been turned on"
else
if getverbosity()==1 then
Say(msg4, ot_message) ;"Standard calculator on"
else
if getverbosity()==2 then
Say(msg5, ot_message) ;"standard calculator"
endif
endif
endif
Else
{alt+v}
{s}
while GetScreenecho()!=echo
ScreenEcho()
Endwhile
while GetVerbosity()!=verb
VerbosityLevel()
Endwhile
if getverbosity()==0 then
Say(msg6, ot_message) ;"The scientific calculator has been turned on"
else
if getverbosity()==1 then
Say(msg7, ot_message) ;"scientific calculator on"
else
if getverbosity()==2 then
Say(msg8, ot_message) ;"scientific calculator"
endif
endif
endif
endif
EndScript

Script SayWindowTitle ()
var
  string SWindowName  
  let SWindowName = GetWindowName (GetRealWindow (GetCurrentWindow ()))
  Say(TitleEquals, ot_message) ;"Title Equals"
If (CalculatorView == StandardCalculator) then
  Say(StandardCalculatorView + SWindowName, ot_window_name)
Else
  Say(ScientificCalculatorView + SWindowName, ot_window_name)
EndIf
EndScript

Function SayFocusedWindow ()
var
handle WinHandle,
  string SWindowName
  let WinHandle = FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), SIN_Button)
  let SWindowName = GetWindowName (GetRealWindow (GetCurrentWindow ()))
If (WinHandle) then
  let CalculatorView = ScientificCalculator
  Say(ScientificCalculatorView + SWindowName, ot_window_name)
Else
  let CalculatorView = Standardcalculator
  Say(StandardCalculatorView + SWindowName, ot_window_name)
EndIf
EndFunction

Void Function SayCalculatorDisplay ()
  Saycontrol (FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), CalculatorDisplay))
EndFunction

Script SayDisplay ()
  SayCalculatorDisplay ()
EndScript

Script ExecuteProcess ()
{=}
Pause ()
SayCalculatorDisplay ()
EndScript

Script ClearCalculatorDisplay ()
{Escape}
Pause ()
SayCalculatorDisplay ()
EndScript

Script CopyDisplayToClipBoard ()
{Control + C}
Pause ()
SayCalculatorDisplay ()
say(msg9, ot_message) ;"Copied Contents of display to the clip board"
EndScript

Script JawsBackSpace ()
{Back Space}
Say(msg10, ot_message) ;"Back one"
EndScript

Script Reciprocal ()
If (MenusActive ()) then
  {R}
else
  {R}
  Say(msg11, ot_message) ;"reciprical"
  sayCalculatorDisplay ()
EndIf
EndScript

Script RecallValueFromMemory ()
var 
int IVerbosity
  let IVerbosity = GetVerbosity ()
{control + R}
If (IVerbosity == beginner) then
  Say(msg12, ot_message) ;"Recalled from memory"
endIf
If (IVerbosity == intermediate) then
    Say(msg13, ot_message) ;"Recalled"
EndIf 
SayCalculatorDisplay ()
EndScript

Script AddDisplayToMemory  ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
{Control + P}
SayCalculatorDisplay ()
If (IVerbosity == beginner) then
  Say(msg14, ot_message) ;"Added value to memory"
endIf 
If (IVerbosity == intermediate) then
  say(msg15, ot_message) ;"Added"
endIf
EndScript

Script ClearMemory ()
var 
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
{Control + L}
If (IVerbosity == beginner) then
  Say(msg16, ot_message) ;"Cleared Value from memory"
EndIf
If (IVerbosity == intermediate || IVerbosity == advanced) then
  Say(msg17, ot_message) ;"memory cleared"
EndIf
EndScript

Script SignToggle ()
var 
  int IVerbosity
  let IVerbosity = GetVerbosity ()
{F9}
If (IVerbosity == beginner) then
   Say(msg18, ot_message) ;"Sign Changed"
EndIf
SayCalculatorDisplay ()   
EndScript

Script SquareRoot ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
{Shift + 2}
If (IVerbosity == beginner) then
If (calculatorView == StandardCalculator) then
  Say(msg19, ot_message) ;"Square Root"
Else
  Say(msg20, ot_message) ;"Square"
EndIf
EndIf
  Pause ()
  SayCalculatorDisplay ()
EndScript

Script StoreDisplayToMemory ()
var 
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
{Control + M}
If (IVerbosity == beginner) then
  Say(msg21, ot_message) ;"Stored in Memory"
Else 
  Say(msg22, ot_message) ;"Stored"
EndIf 
SayCalculatorDisplay ()
EndScript

Script FactorialDisplay ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
if (IVerbosity == beginner) then
  Say(msg23, ot_message) ;"You must turn on the scientific calculator to use this feature"
ElIf (IVerbosity == intermediate) then
  Say(msg24, ot_message) ;"Not in scientific mode"
ElIf (IVerbosity == advanced) then
  Say(msg25, ot_message) ;"not available"
EndIf 
  Return
EndIf    
  {;}
    Say(msg26, ot_message) ;"Factorial"
  {Shift + 1}
  SayCalculatorDisplay ()
EndScript

Script GetIntegerPartOfDisplay ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say(msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say(msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say(msg25, ot_message)
endIf
  Return
EndIf
  {;}
  SayCalculatorDisplay ()
EndScript

Script NaturalLogDisplay ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {N}
  SayCalculatorDisplay ()
EndScript

Script CommonLogDisplay ()
var 
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {L}
  SayCalculatorDisplay ()
EndScript

Script TenToXTh ()
var 
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {I}
  {L}
  SayCalculatorDisplay ()
EndScript

Script EToXTH ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {I}
  {N}
  sayCalculatorDisplay ()
EndScript

Script GetFractionalPartOfDisplay ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  Say(msg27, ot_message) ;"Fractional Part of display"
  {I}
  {;}
  SayCalculatorDisplay ()
EndScript

Script HexidecimalMode ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {F5}
If (IVerbosity == beginner) then
  Say(msg28, ot_message) ;"calculator is in hexidecimal mode"
ElIf (IVerbosity > beginner) then 
  Say(msg29, ot_message) ;"Hexidecimal Mode"
endIf
EndScript

Script DecimalMode ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {F6}
If (IVerbosity == beginner) then
  Say(msg30, ot_message) ;"decimal Mode"
ElIf (IVerbosity > beginner) then 
  Say(msg31, ot_message) ;"Decimal Mode"
EndIf 
EndScript

Script OctalMode ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {F7}
If (IVerbosity == beginner) then
  Say(msg32, ot_message) ;"calculator in octal mode"
ElIf (IVerbosity > beginner) then 
  Say(msg33, ot_message) ;"Octal Mode"
endIf 
EndScript

Script BinaryMode ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {F8}
If (IVerbosity == beginner) then 
  Say(msg34, ot_message) ;
ElIf (IVerbosity > beginner) then
  Say(msg35, ot_message) ;"Binary Mode"
endIf
EndScript

Script ScientificNotationToggle ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  {V}
  SayCalculatorDisplay ()
EndScript

Script CubeDisplay ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  SayCalculatorDisplay ()
  Say(msg36, ot_message) ;"to the third power"
  {Shift + 3}
  SayCalculatorDisplay ()
EndScript

Script CubeRootDisplay ()
var
  int IVerbosity 
  let IVerbosity = GetVerbosity ()
If (CalculatorView != ScientificCalculator) then
If (IVerbosity == beginner) then
  Say (msg23, ot_message)
ElIf (IVerbosity == intermediate) then
  Say (msg24, ot_message)
Elif (IVerbosity == advanced) then
  Say (msg25, ot_message)
endIf
  Return
EndIf
  Say(msg37, ot_message) ;"the cubed root of"
  SayCalculatorDisplay ()
  say(msg38, ot_message) ;"is"
  {I}
  {Shift + 3}
  SayCalculatorDisplay ()
EndScript

Script SayLine ()
If(MenusActive () || DialogActive ()) then
  PerformScript SayLine()
  Return
Else
SayCalculatorDisplay ()
EndIf
EndScript

Script ScreenSensitiveHelp ()
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
If (CalculatorView == StandardCalculator) then
  Say(msg45, ot_message) ;"You are in the Standard Calculator Window"
  Say(msg1, ot_help)
Else
  Say(msg46, ot_message) ;"You are in the Scientific Calculator Window"
  Say(msg1, ot_help)
EndIf
EndScript

Script HotKeyHelp ()
Say(msg47, ot_help) ;"use the following hot keys with Standard or scientific calculator"
Say(msg48, ot_help) ;"To toggle between standard and scientific calculators,"
Say(msg49 + GetScriptKeyName ("CalculatorToggle"), ot_help) ;"use the letter z"
Say(msg50 + GetScriptKeyName ("SayWindowtitle"), ot_help) ;"to find out which calculator is active, use insert plus t"
Say(msg51 + GetScriptKeyName ("SayDisplay"), ot_help) ;"to read the value in the display, use Control + Alt + d"
Say(msg53, ot_help) ;"to put the result of a calculation in the display,"
Say(msg54 + GetScriptKeyName ("ExecuteProcess"), ot_help) ;"you can also use the = sign or ENTER key"
Say(msg55 + GetScriptKeyName ("ClearCalculatorDisplay"), ot_help) ;"to clear the display, use alt plus d"
Say(msg56 + GetScriptKeyName ("ClearCalculatorDisplay"), ot_help) ;"to clear the calculator, use Escape or Delete"
Say(msg57 + GetScriptKeyName ("ClearMemory"), ot_help) ;"To clear the memory, use alt+c"
Say(msg58 + GetScriptKeyName ("StoreDisplayToMemory"), ot_help) ;"To store displayed value in memory, use S"
Say(msg59 + GetScriptKeyName ("AddValueToMemory"), ot_help) ;"To add displayed value to value in memory, use Control + P"
Say(msg60 + GetScriptKeyName ("RecallValueFromMemory"), ot_help) ;"To recall value from memory, use alt+r"
Say(msg61 + GetScriptKeyName ("SignToggle"), ot_help) ;"To change the sign of displayed value, use n"
Say(msg62 + GetScriptKeyName ("Reciprical"), ot_help) ;"To get reciprocal of displayed value, use R"
Say(msg63 + GetScriptKeyName ("SquareRoot"), ot_help) ;"To get square root of displayed value, use q"
If (CalculatorView == ScientificCalculator) then
Say(msg64, ot_help) ;"The following hotkeys are for use with the scientificcalculator"
Say(msg65, ot_help) ;"To enter hexidecimal numbers, use f5"
Say(msg66, ot_help) ;"When in hex mode, to enter the value A, use a"
Say(msg67, ot_help) ;"When in hex mode, to enter the value b, use b"
Say(msg68, ot_help) ;"When in hex mode, to enter the value c, use c"
Say(msg69, ot_help) ;"When in hex mode, to enter the value d, use d"
Say(msg70, ot_help) ;"When in hex mode, to enter the value e, use e"
Say(msg71, ot_help) ;"When in hex mode, to enter the value f, use f"
Say(msg72, ot_help) ;"To enter decimal numbers, use f6"
Say(msg73, ot_help) ;"to enter octal numbers, use f7"
Say(msg74, ot_help) ;"To enter binary numbers, use f8"
Say(msg75, ot_help) ;"To convert numbers to the decimal number system, use shift+d"
Say(msg76, ot_help) ;"To convert numbers to the hexidecimal number system, use shift+h"
Say(msg77, ot_help) ;"To convert numbers to the octal number system, use shift+o"
Say(msg78, ot_help) ;"To convert numbers to the binary number system, use shift+b"
Say(msg79, ot_help) ;"To do trigonometric functions with degrees, use f2"
Say(msg80, ot_help) ;"To do trigonometric functions with radians, use f3"
Say(msg81, ot_help) ;"To do trigonometric functions with gradients, use f4"
Say(msg82, ot_help) ;"To get the sine of a value, use shift+s"
Say(msg83, ot_help) ;"To get the arc sine of the displayed value, use alt+s"
Say(msg84, ot_help) ;"To get the hyperbolic sine of the displayed value, use control+s"
Say(msg85, ot_help) ;"to get arc hyperbolic sine of displayed value, use shift+control+s"
Say(msg86, ot_help) ;"To get the cosine of displayed value, use o"
Say(msg87, ot_help) ;"To get the arc cosine of displayed value, use alt+o"
Say(msg88, ot_help) ;"To get hyperbolic cosine of display, use control+o"
Say(msg89, ot_help) ;"To get arc hyperbolic cosine, use shift+control+o"
Say(msg90, ot_help) ;"To get the tangent of displayed value, use t"
Say(msg91, ot_help) ;"To get arc tangent of the display, use alt+t"
Say(msg92, ot_help) ;"To get hyperbolic tangent of display, use control+t"
Say(msg93, ot_help) ;"To get arc tangent of the display, use alt+t"
Say(msg94, ot_help) ;"To get hyperbolic tangent of display, use control+t"
Say(msg95, ot_help) ;"To get arc hyperbolic tangent, use shift+control+t"
Say(msg96 + GetScriptKeyName ("ScientificNotationToggle"), ot_help) ;"To convert display to or from scientific notation, use v"
Say(msg97, ot_help) ;"To convert display to degree-minute-second format, use m"
Say(msg98, ot_help) ;"To convert display from degree-minute-second format, use shift+m"
Say(msg99 + GetScriptKeyName ("CommonLogDisplay"), ot_help) ;"To get the common logarithm of displayed value, use l"
Say(msg100 + GetScriptKeyName ("TenToXTh"), ot_help) ;"To get 10 to the x power, use alt+l"
Say(msg101 + GetScriptKeyName ("EToXTH"), ot_help) ;"To get E to the x power, use shift+e"
Say(msg102 + GetScriptKeyName ("NaturalLogDisplay"), ot_help) ;"To get the natural logarithm of displayed value, use alt+e"
Say(msg103 + GetScriptKeyName ("FactorialDisplay"), ot_help) ;"To get factorial of display, use shift+1"
Say(msg104 + GetScriptKeyName ("GetIntegerPartOfDisplay"), ot_help) ;"To get integer part of display, use i"
Say(msg105 + GetScriptKeyName ("GetFractionalPartOfDisplay"), ot_help) ;"To get fractional part of display, use shift+f"
Say(msg106	, ot_help) ;"To get square of displayed value, use alt+q"
Say(msg107 + GetScriptKeyName ("CubeDisplay"), ot_help) ;"To get cube of displayed value, use shift+3"
Say(msg108 + GetScriptKeyName ("CubeRootDisplay"), ot_help) ;"To get cube root of displayed value, use alt+3"
EndIf
EndScript

Script SayDisplayEnter ()
If (MenusActive () || DialogActive ()) then
  {Enter}
  Return
Else
  {=}
  Pause ()
  SayCalculatorDisplay ()
EndIf
EndScript

Script SquareDisplay ()
;Get the square of display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom,s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg109, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg110, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg111, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18,  s_bottom,s_unrestricted)) then
{shift+2}
Say(msg112, ot_message) ;"Square "
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PCCursor()
Endif
EndScript